<?php
function my_theme_enqueue_styles() { 
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

add_action( 'wp_footer', 'custom_trigger_ajax_add_to_cart' );
function custom_trigger_ajax_add_to_cart() {
    ?>
        <script type="text/javascript">
            (function($){
                $('body').on( 'added_to_cart', function(){
                    ///Your action
                });
            })(jQuery);
        </script>
    <?php
}

// Replace Add to Cart button with custom Out of Stock message when product is out of stock
function replace_add_to_cart_with_out_of_stock_message() {
    global $product;
    if ( !$product->is_in_stock() ) {
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
        echo '<div class="custom-out-of-stock-message" style="color:red; font-weight:bold;">Sorry, this product is currently out of stock. Check back soon!</div>';
    }
}
add_action( 'woocommerce_single_product_summary', 'replace_add_to_cart_with_out_of_stock_message', 1 );



